* ---------------------------------------------------
* Event History Analysis
* Josef Brderl, March 2008
* Entry into Motherhood
* 1 ) constructing the data
* ---------------------------------------------------

* Load data from ALLBUS 2000
use "I:\Uni\VLongitudinal\VL Event History\Beispiel\allb00.dta", clear

* ----------------------------------
* Data Selection: only German women
* ----------------------------------

* Drop men (V216=gender)
drop if v216 < 2
* Only Germans (v4=Staatsangehrigkeit)
drop if v4 > 1

* ---------------------------------------------------
* Constructing age at birth of first child
* Unfortunately, there is no question on this in the data
* However, we know how old the children are
* (we use only "age", more exact would be to use "birth year and month")
* ---------------------------------------------------

* children in household
gen alterih = v219                      // age of respondent
gen alterk1 = v493 if(v489==3) 
gen alterk2 = v500 if(v496==3)
gen alterk3 = v507 if(v503==3)
gen alterk4 = v514 if(v510==3)
gen alterk5 = v521 if(v517==3)
gen alterk6 = v528 if(v524==3)
gen alterk7 = v535 if(v531==3)
gen alterk= max(alterk1, alterk2, alterk3, alterk4, alterk5, alterk6, alterk7)
replace alterih = alterih - alterk     // age at birth oldest child in household

* children not in household
gen alterah = v219
gen altchild = max(v549, v553, v557, v561, v565, v569, v573, v577, v581)
replace alterah = alterah - altchild   // age at birth oldest child not in household

* age at birth oldest child
gen gebal = min(alterih, alterah)

* failure indicator: 1 (child) 0 (no child)
gen child=.
replace child = 0 if (v546==3)
replace child = 1 if (v546<=2 & gebal<60)

* Drop cases with missing on failure indicator
drop if child == .                     // these cases would be treated as censored!

* duration
generate duration = gebal - 14
replace  duration = v219  - 14 if (child == 0)         // those without kids

* -------------------------------------------
* Constructing covariates
* -------------------------------------------

* Education in years 
recode v221 1=8 2=9 3=10 4=12 5=13 6=10 7=10
gen educ=v221
replace educ=educ+0.5 if (v222==1)/*Beruflich-betriebliche Anlernduration*/
replace educ=educ+1 if (v223==1)  /*Teilfacharbeiterabschluss*/
replace educ=educ+1.5 if (v224==1)/*Gewerbliche, landwirtschaftliche, Lehre*/
replace educ=educ+1.5 if (v225==1)/*Kaufmaennische Lehre*/
replace educ=educ+0.5 if (v226==1)/*Beruflich. Praktikum, Volontariat*/
replace educ=educ+1.5 if (v227==1)/*Fachschulabschluss*/
replace educ=educ+2 if (v228==1)  /*Berufsfachschulabschluss*/
replace educ=educ+3 if (v229==1)  /*Meister, Technikerabschluss*/
replace educ=educ+4 if (v230==1)  /*Fachhochschulabschluss*/
replace educ=educ+5 if (v231==1)  /*Hochschulabschluss*/
replace educ=educ+0.5 if (v232==1)/*Anderer Berufsausbildungsabschluss*/
replace educ=educ+0 if (v233==1)  /*kein berufl. Ausbildungsabschluss*/

* East/West dummy
gen east=v467
recode east 1 3=0 2 4 =1
label var east "origin"
label define originlbl 0 "west" 1 "east"
label value east originlbl

* Birth cohort dummies
gen cohort=v218
recode cohort 1904/1925=1 1926/1940=2 1941/1950=3 1951/1965=4 1966/1981=5
label var cohort "cohort"
tab cohort, gen (coh)

* Generate id variable
gen persnr = _n

* Slim the dataset
keep persnr duration child educ east cohort coh1-coh5
save "I:\Uni\VLongitudinal\VL Event History\Beispiel\motherhood.dta", replace


